import { ExecType } from './command';
import { Tab } from '../webapp/cli';
import { Streamable, StreamableFactory } from './streamable';
import { Block } from '../webapp/models/block';
import { Abortable } from '../core/jobs/job';
export interface ExecOptions {
    tab?: Tab;
    env?: Record<string, string>;
    render?: boolean;
    isProxied?: boolean;
    forceProxy?: boolean;
    noDelegation?: boolean;
    delegationOk?: boolean;
    leaveBottomStripeAlone?: boolean;
    filter?: any;
    contextChangeOK?: boolean;
    credentials?: Record<string, any>;
    custom?: any;
    rawResponse?: boolean;
    isDrilldown?: boolean;
    block?: Block;
    nextBlock?: HTMLElement;
    placeholder?: string;
    replSilence?: boolean;
    quiet?: boolean;
    intentional?: boolean;
    noHistory?: boolean;
    pip?: {
        container: string;
        returnTo: string;
    };
    history?: number;
    echo?: boolean;
    nested?: boolean;
    failWithUsage?: boolean;
    rethrowErrors?: boolean;
    reportErrors?: boolean;
    preserveBackButton?: boolean;
    type?: ExecType;
    exec?: 'pexec' | 'qexec' | 'rexec';
    container?: Element;
    raw?: boolean;
    createOnly?: boolean;
    noHeader?: boolean;
    noStatus?: boolean;
    noSidecarHeader?: boolean;
    noRetry?: boolean;
    showHeader?: boolean;
    alreadyWatching?: boolean;
    createOutputStream?: StreamableFactory;
    stdout?: (str: Streamable) => any;
    stderr?: (str: string) => any;
    onInit?: (job: Abortable) => (str: Streamable) => void;
    parameters?: any;
    entity?: any;
}
export interface LanguageBearing extends ExecOptions {
    language: string;
}
export declare function hasLanguage(execOptions: ExecOptions): execOptions is LanguageBearing;
export declare function withLanguage(execOptions: ExecOptions): LanguageBearing;
export declare class DefaultExecOptions implements ExecOptions {
    readonly type: ExecType;
    readonly language: string;
    constructor(type?: ExecType);
}
export declare class DefaultExecOptionsForTab extends DefaultExecOptions {
    readonly tab: Tab;
    constructor(tab: Tab);
}
