import { ParsedOptions } from '../command';
import { Tab } from '../../webapp/tab';
import { Table } from '../../webapp/models/table';
import { Entity, MetadataBearing } from '../entity';
import { CustomSpec } from '../../webapp/views/sidecar-core';
import { SidecarMode } from '../../webapp/bottom-stripe';
export declare type ScalarResource = CustomSpec | string | HTMLElement | Table;
export interface ScalarContent<T = ScalarResource> {
    content: T;
}
export declare function isScalarContent<T extends MetadataBearing>(entity: Entity | ScalarResource | ScalarContent | Content<T> | MetadataBearing | SidecarMode): entity is ScalarContent;
declare type SupportedStringContent = 'yaml' | 'text/markdown' | 'text/html' | 'json';
interface WithOptionalContentType<ContentType = SupportedStringContent> {
    contentType?: ContentType;
}
export declare type StringContent<ContentType = SupportedStringContent> = ScalarContent<string> & WithOptionalContentType<ContentType>;
export declare function isStringWithOptionalContentType<T extends MetadataBearing>(entity: Entity | Content<T> | MetadataBearing | SidecarMode): entity is StringContent;
export declare type FunctionThatProducesContent<T extends MetadataBearing> = (tab: Tab, entity: T, args: {
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
}) => ScalarResource | ScalarContent | CommandStringContent | Promise<ScalarResource> | Promise<ScalarContent>;
export interface FunctionContent<T extends MetadataBearing> {
    content: FunctionThatProducesContent<T>;
}
export declare function isFunctionContent<T extends MetadataBearing>(content: Entity | Content<T> | MetadataBearing | SidecarMode): content is FunctionContent<T>;
declare type CommandStringContent = WithOptionalContentType<SupportedStringContent> & {
    contentFrom: string;
};
export declare function isCommandStringContent<T extends MetadataBearing>(content: ScalarResource | Content<T> | MetadataBearing | SidecarMode): content is CommandStringContent;
export declare type Content<T extends MetadataBearing> = ScalarContent | StringContent | FunctionContent<T> | CommandStringContent;
export declare function hasContent<T extends MetadataBearing>(resource: ScalarResource | Content<T> | SidecarMode): resource is Content<T>;
export {};
