"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const custom_content_1 = require("../../webapp/views/custom-content");
const bottom_stripe_1 = require("../../webapp/bottom-stripe");
const table_1 = require("../../webapp/models/table");
const types_1 = require("./types");
const content_types_1 = require("./content-types");
function formatForTab(tab, mmr, resource, args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!content_types_1.hasContent(resource)) {
            return formatForTab(tab, mmr, { content: resource }, args);
        }
        else if (content_types_1.isFunctionContent(resource)) {
            return formatForTab(tab, mmr, yield resource.content(tab, mmr, args), args);
        }
        else if (content_types_1.isCommandStringContent(resource)) {
            const content = yield tab.REPL.qexec(resource.contentFrom);
            if (resource.contentType && typeof content === 'string') {
                return formatForTab(tab, mmr, {
                    content,
                    contentType: resource.contentType
                }, args);
            }
            else {
                return formatForTab(tab, mmr, content, args);
            }
        }
        else if (custom_content_1.isCustomSpec(resource.content)) {
            return resource.content;
        }
        else if (table_1.isTable(resource.content)) {
            return resource.content;
        }
        else {
            return Object.assign({ resource: mmr, toolbarText: mmr.toolbarText, kind: mmr.kind, metadata: mmr.metadata, type: 'custom' }, resource);
        }
    });
}
exports.formatForTab = formatForTab;
function wrapTable(tab, table, args) {
    return __awaiter(this, void 0, void 0, function* () {
        const dom1 = document.createElement('div');
        const dom2 = document.createElement('div');
        dom1.classList.add('scrollable', 'scrollable-auto');
        dom2.classList.add('result-as-table', 'repl-result');
        dom1.appendChild(dom2);
        const { formatTable } = yield Promise.resolve().then(() => require('../../webapp/views/table'));
        formatTable(tab, table, dom2, args);
        return dom1;
    });
}
function renderContent(tab, bearer, content, args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (content_types_1.isStringWithOptionalContentType(content)) {
            return content;
        }
        else if (content_types_1.isFunctionContent(content)) {
            const actualContent = (yield content.content(tab, bearer, args));
            if (!content_types_1.isScalarContent(actualContent)) {
                if (table_1.isTable(actualContent)) {
                    return {
                        content: yield wrapTable(tab, actualContent, args)
                    };
                }
                else {
                    return {
                        content: actualContent
                    };
                }
            }
            else {
                return actualContent;
            }
        }
        else if (content_types_1.isScalarContent(content)) {
            if (table_1.isTable(content.content)) {
                return {
                    content: yield wrapTable(tab, content.content, args)
                };
            }
            else {
                return content;
            }
        }
        else if (table_1.isTable(content)) {
            return {
                content: yield wrapTable(tab, content, args)
            };
        }
        else if (content_types_1.isCommandStringContent(content)) {
            return {
                content: yield tab.REPL.qexec(content.contentFrom),
                contentType: content.contentType
            };
        }
    });
}
function show(tab, mmr, args) {
    return __awaiter(this, void 0, void 0, function* () {
        const modes = mmr.modes;
        const ourModesWithButtons = modes.concat(mmr.buttons || []);
        const modesWithButtons = bottom_stripe_1.addModeButtons(tab, ourModesWithButtons, mmr, args, {
            preserveBackButton: true,
            show: mmr.defaultMode,
            modelOnly: true
        });
        const defaultMode = modesWithButtons.find(_ => !types_1.isButton(_) && _.defaultMode) || modesWithButtons.find(_ => !types_1.isButton(_));
        if (types_1.isButton(defaultMode)) {
            console.error('default mode is a button', defaultMode.mode, modesWithButtons, mmr);
            throw new Error('default mode is a button');
        }
        const content = content_types_1.hasContent(defaultMode) ? yield renderContent(tab, mmr, defaultMode, args) : undefined;
        bottom_stripe_1.addModeButtons(tab, ourModesWithButtons, mmr, args, {
            preserveBackButton: true,
            show: mmr.defaultMode
        });
        if (content) {
            const custom = Object.assign({
                type: 'custom',
                resource: mmr,
                modes: modesWithButtons,
                toolbarText: mmr.toolbarText,
                prettyName: mmr.prettyName,
                nameHash: mmr.nameHash
            }, content);
            const { showCustom } = yield Promise.resolve().then(() => require('../../webapp/views/sidecar'));
            return showCustom(tab, custom, { leaveBottomStripeAlone: true });
        }
        else {
            console.error('empty content');
        }
    });
}
exports.show = show;
//# sourceMappingURL=show.js.map