import { Tab } from '../webapp/cli';
import { MixedResponse, RawContent, RawResponse } from './entity';
import { EvaluatorArgs, KResponse } from './command';
import { ExecOptions } from './execOptions';
export default interface REPL {
    qexec<T extends KResponse>(command: string, block?: HTMLElement | boolean, contextChangeOK?: boolean, execOptions?: ExecOptions, nextBlock?: HTMLElement): Promise<T>;
    rexec<Raw extends RawContent>(command: string, execOptions?: ExecOptions): Promise<RawResponse<Raw>>;
    pexec<T extends KResponse>(command: string, execOptions?: ExecOptions): Promise<T>;
    click(command: string | (() => Promise<string>), evt: MouseEvent): Promise<void>;
    update(tab: Tab, command: string, execOptions?: ExecOptions): Promise<void>;
    semicolonInvoke(opts: EvaluatorArgs): Promise<MixedResponse>;
    encodeComponent(component: string | number | boolean, quote?: string): string;
    split(str: string, removeOuterQuotes?: boolean, removeInlineOuterQuotes?: boolean): string[];
}
