import { PrescanModel } from './prescan';
import { CommandBase } from '../models/command';
import { KuiPlugin } from '../models/plugin';
export interface PluginResolver {
    resolve: (route: string, options?: {
        subtree?: boolean;
        tryCatchalls: boolean;
    }) => void;
    disambiguate: (route: string) => CommandBase[];
    disambiguatePartial: (partial: string) => string[];
    resolveOne: (plugin: string) => Promise<KuiPlugin>;
    isOverridden: (route: string) => boolean;
    isAlpha: (route: string, plugin: string) => boolean;
}
export declare const makeResolver: (prescan: PrescanModel, registrar: Record<string, KuiPlugin>) => PluginResolver;
