"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const fs_1 = require("fs");
const headless_pretty_print_1 = require("../main/headless-pretty-print");
const debug = debug_1.default('util/tee');
function default_1(response) {
    try {
        const stream = fs_1.createWriteStream(process.env.KUI_TEE_TO_FILE);
        const logger = (data) => stream.write(data);
        try {
            headless_pretty_print_1.print(response, logger, stream);
            if (process.env.KUI_TEE_TO_FILE_END_MARKER) {
                stream.write(process.env.KUI_TEE_TO_FILE_END_MARKER);
            }
        }
        finally {
            stream.end();
            if (process.env.KUI_TEE_TO_FILE_EXIT_ON_END_MARKER) {
                try {
                    const { app } = require('electron').remote;
                    debug('attempting to quit', app);
                    app.quit();
                }
                catch (err) {
                    console.error('Error exiting', err);
                }
            }
        }
    }
    catch (err) {
        debug('error teeing output to console');
        console.error(err);
    }
}
exports.default = default_1;
//# sourceMappingURL=tee.js.map