"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const listen_1 = require("./listen");
const prompt_1 = require("./prompt");
const block_1 = require("./block");
exports.default = () => {
    const block = block_1.removeAnyTemps(block_1.getCurrentProcessingBlock() || block_1.getCurrentBlock());
    if (block.restorePrompt) {
        block.restorePrompt();
    }
    const nextBlock = block.cloneNode(true);
    const nextBlockPrompt = prompt_1.getPrompt(nextBlock);
    block_1.removeAnyTemps(nextBlock, true);
    block.className = `${block.getAttribute('data-base-class')} cancelled`;
    block.isCancelled = true;
    nextBlockPrompt.value = '';
    nextBlockPrompt.readOnly = false;
    listen_1.unlisten(prompt_1.getPrompt(block));
    block_1.installBlock(block.parentNode, block, nextBlock)();
};
//# sourceMappingURL=cancel.js.map