import { MetadataBearing, Entity } from '../../models/entity';
import { SidecarMode } from '../bottom-stripe';
export declare class Row {
    attributes?: Cell[];
    rowKey?: string;
    key?: string;
    name: string;
    nameDom?: Element;
    type?: string;
    packageName?: string;
    prettyType?: string;
    fontawesome?: string;
    fontawesomeCSS?: string;
    setSelected?: () => void;
    setUnselected?: () => void;
    nameCss?: string | string[];
    prettyName?: string;
    fullName?: string;
    kind?: string;
    prettyKind?: string;
    status?: string;
    version?: string;
    prettyVersion?: string;
    beforeAttributes?: Cell[];
    rowCSS?: string | string[];
    onclickSilence?: boolean;
    onclickExec?: 'pexec' | 'qexec';
    onclick?: any;
    css?: string;
    outerCSS?: string;
    done?: boolean;
    constructor(row: Row);
}
export declare class Cell {
    value: string;
    valueDom?: Node[] | Node;
    css?: string;
    outerCSS?: string;
    onclick?: any;
    key?: string;
    fontawesome?: string[] | string;
    tag?: string;
    tagClass?: string;
    innerClassName?: string;
    className?: string;
    constructor(cell: Cell);
}
export interface Button {
    name: string;
    fontawesome: string;
    balloon?: string;
    onclick: (evt: Event) => void | string;
}
export interface Footer {
    leftButtons: Button[];
}
export declare enum TableStyle {
    Light = 0,
    Medium = 1,
    Heavy = 2
}
export declare class Table<RowType extends Row = Row> {
    body: RowType[];
    style?: TableStyle;
    header?: RowType;
    footer?: Footer;
    noSort?: boolean;
    noEntityColors?: boolean;
    title?: string;
    flexWrap?: number | boolean;
    tableCSS?: string;
    fontawesome?: string;
    fontawesomeCSS?: string;
    fontawesomeBalloon?: string;
    constructor(table: Table);
}
export declare function isTable<C>(model: SidecarMode | MetadataBearing<C> | Entity): model is Table;
export declare const sortBody: (rows: Row[]) => Row[];
export declare class Icon {
    fontawesome: string;
    onclick?: (evt: Event) => void;
    balloon?: string;
    balloonLength?: string;
    balloonPos?: string;
    constructor(icon: Icon);
}
