"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Row {
    constructor(row) {
        Object.assign(this, row);
    }
}
exports.Row = Row;
class Cell {
    constructor(cell) {
        Object.assign(this, cell);
    }
}
exports.Cell = Cell;
var TableStyle;
(function (TableStyle) {
    TableStyle[TableStyle["Light"] = 0] = "Light";
    TableStyle[TableStyle["Medium"] = 1] = "Medium";
    TableStyle[TableStyle["Heavy"] = 2] = "Heavy";
})(TableStyle = exports.TableStyle || (exports.TableStyle = {}));
class Table {
    constructor(table) {
        Object.assign(this, table);
    }
}
exports.Table = Table;
function isTable(model) {
    return (model !== undefined && (model instanceof Table || (model.body && Array.isArray(model.body))));
}
exports.isTable = isTable;
exports.sortBody = (rows) => {
    return rows.sort((a, b) => (a.prettyType || a.type || '').localeCompare(b.prettyType || b.type || '') ||
        (a.packageName || '').localeCompare(b.packageName || '') ||
        a.name.localeCompare(b.name));
};
class Icon {
    constructor(icon) {
        Object.assign(this, icon);
    }
}
exports.Icon = Icon;
//# sourceMappingURL=table.js.map