"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('webapp/oops');
debug('loading');
const prompt_1 = require("./prompt");
const status_1 = require("./status");
const listen_1 = require("./listen");
const block_1 = require("./block");
const popup_core_1 = require("./popup-core");
const popup_1 = require("./popup");
const types_1 = require("../util/types");
const oops_1 = require("../core/oops");
const usage_error_1 = require("../core/usage-error");
const errors_1 = require("../models/errors");
function isPopupError(err) {
    return err.content !== undefined;
}
exports.oops = (command, block, nextBlock) => (err) => __awaiter(void 0, void 0, void 0, function* () {
    if (!block)
        return;
    if (!nextBlock) {
        nextBlock = block.cloneNode(true);
        nextBlock.querySelector('input').value = '';
    }
    if (prompt_1.getPrompt(block).value === '') {
        prompt_1.getPrompt(block).value = command;
    }
    status_1.setStatus(block, "error");
    const resultDom = popup_core_1.isPopup() ? popup_1.createPopupContentContainer(['error']) : block.querySelector('.repl-result');
    const oopsDom = document.createElement('div');
    oopsDom.className = 'oops';
    resultDom.appendChild(oopsDom);
    if (errors_1.isHideError(err)) {
        debug('we were instructed to hide this error', err);
        oopsDom.classList.add('hidden');
    }
    else if (usage_error_1.default.isUsageError(err)) {
        oopsDom.appendChild(yield usage_error_1.default.getFormattedMessage(err));
    }
    else if (types_1.isHTML(err)) {
        oopsDom.appendChild(err);
    }
    else {
        const message = oops_1.oopsMessage(err);
        const span = document.createElement('pre');
        span.appendChild(document.createTextNode(message));
        oopsDom.appendChild(span);
    }
    if (errors_1.isCodedError(err)) {
        oopsDom.setAttribute('data-status-code', (err.statusCode || err.code).toString());
    }
    else {
        oopsDom.setAttribute('data-status-code', '0');
    }
    if (resultDom.hasAttribute('data-stream')) {
        const streamingOutput = resultDom.querySelector('.streaming-output');
        if (streamingOutput) {
            oopsDom.appendChild(streamingOutput);
        }
    }
    if (popup_core_1.isPopup()) {
        yield popup_1.renderPopupContent(command, (isPopupError(err) && err.content) || resultDom, {}, isPopupError(err) && err.modes);
        listen_1.popupListen(undefined, command);
    }
    block_1.installBlock(block.parentNode, block, nextBlock)();
    return false;
});
exports.showHelp = (command, block, nextBlock, error) => {
    const baseMessage = 'Enter help to see your options.';
    if (error.message && error.message === 'Command not found')
        error.message += `\n${baseMessage}`;
    return exports.oops(command, block, nextBlock)(error) && false;
};
//# sourceMappingURL=oops.js.map