"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const popup_core_1 = require("./popup-core");
const block_1 = require("./block");
const tab_1 = require("./tab");
const sidecar_core_1 = require("./views/sidecar-core");
const execOptions_1 = require("../models/execOptions");
const capabilities_1 = require("../core/capabilities");
const settings_1 = require("../core/settings");
exports.getBlockOfPrompt = (prompt) => {
    return prompt.parentElement.parentElement;
};
exports.getPrompt = (block) => {
    return block && block.querySelector && block.querySelector('input');
};
exports.getBottomPrompt = () => {
    return exports.getPrompt(document.querySelector('.kui--input-stripe .repl-block'));
};
exports.getInitialPrompt = (tab) => {
    return exports.getPrompt(block_1.getInitialBlock(tab));
};
exports.getCurrentPrompt = (tab = tab_1.getCurrentTab()) => {
    if (popup_core_1.isPopup()) {
        return sidecar_core_1.getSidecar(tab).querySelector('input');
    }
    else if (settings_1.inBottomInputMode) {
        return exports.getPrompt(document.querySelector('.kui--input-stripe'));
    }
    else {
        return exports.getPrompt(block_1.getCurrentBlock(tab));
    }
};
exports.getPromptFromTarget = (target) => {
    return exports.getCurrentPrompt(tab_1.getTabFromTarget(target));
};
exports.getPromptLeft = (block) => {
    return block.querySelector('.repl-prompt-righty');
};
exports.getCurrentPromptLeft = (tab) => {
    if (settings_1.inBottomInputMode) {
        return exports.getPromptLeft(document.querySelector('.kui--input-stripe'));
    }
    else {
        return exports.getPromptLeft(block_1.getCurrentBlock(tab));
    }
};
function installContext(block) {
    if (capabilities_1.inElectron()) {
        const cwd = process.cwd() === process.env.HOME ? '~' : path_1.basename(process.cwd());
        const promptContextContainer = block.querySelector('.repl-context');
        promptContextContainer.innerText = cwd;
    }
}
exports.installContext = installContext;
function isUsingCustomPrompt(prompt) {
    return exports.getBlockOfPrompt(prompt).classList.contains('using-custom-prompt');
}
exports.isUsingCustomPrompt = isUsingCustomPrompt;
exports.partial = (cmd, execOptions = new execOptions_1.DefaultExecOptions()) => {
    const prompt = exports.getCurrentPrompt();
    if (prompt) {
        prompt.value = cmd;
        prompt.execOptions = execOptions;
        prompt.classList.add('repl-partial');
        prompt.focus();
        setTimeout(() => prompt.classList.remove('repl-partial'), 1000);
    }
    else {
        setTimeout(() => exports.partial(cmd, execOptions), 100);
    }
};
function setUsingCustomPrompt(block) {
    block.classList.add('using-custom-prompt');
}
exports.setUsingCustomPrompt = setUsingCustomPrompt;
function unsetUsingCustomPrompt(block) {
    block.classList.remove('using-custom-prompt');
}
exports.unsetUsingCustomPrompt = unsetUsingCustomPrompt;
//# sourceMappingURL=prompt.js.map