"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const capabilities_1 = require("../core/capabilities");
const debug_1 = require("debug");
const debug = debug_1.default('webapp/query');
debug('loading');
exports.init = () => __awaiter(void 0, void 0, void 0, function* () {
    debug('init');
    if (capabilities_1.inBrowser()) {
        const windowQuery = window.location.search;
        if (windowQuery) {
            const query = require('querystring').parse(windowQuery.substring(1));
            if (query.command) {
                const { pexec } = yield Promise.resolve().then(() => require('../repl/exec'));
                const queryExec = () => pexec(query.command);
                queryExec();
            }
        }
    }
    debug('init done');
});
//# sourceMappingURL=query.js.map