"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const keys_1 = require("./keys");
const cancel_1 = require("./cancel");
const paste_1 = require("./paste");
const block_1 = require("./block");
const tab_1 = require("./tab");
const prompt_1 = require("./prompt");
const capabilities_1 = require("../core/capabilities");
exports.startInputQueueing = (tab) => {
    if (!capabilities_1.isHeadless()) {
        const invisibleHand = document.getElementById('invisible-global-input');
        invisibleHand.focus();
        tab.queueListener = (event) => {
            const char = event.keyCode;
            if (char === keys_1.keys.C && event.ctrlKey) {
                cancel_1.default();
            }
        };
        document.body.addEventListener('keydown', tab.queueListener);
    }
};
let _invisibleHand;
exports.disableInputQueueing = (tab) => {
    if (capabilities_1.isHeadless()) {
        return;
    }
    const invisibleHand = _invisibleHand || (_invisibleHand = document.getElementById('invisible-global-input'));
    if (tab.queueListener) {
        document.body.removeEventListener('keydown', tab.queueListener);
    }
    const queuedInput = invisibleHand.value;
    invisibleHand.value = '';
    return queuedInput;
};
exports.handleQueuedInput = (nextBlock) => __awaiter(void 0, void 0, void 0, function* () {
    const queuedInput = exports.disableInputQueueing(tab_1.getTabFromTarget(nextBlock));
    if (nextBlock && queuedInput && queuedInput.length > 0) {
        let nextPrompt = prompt_1.getPrompt(nextBlock);
        if (nextPrompt) {
            const lines = queuedInput.split(/[\n\r]/);
            const firstNonBlank = lines.findIndex(_ => _.length > 0);
            const nPrefixNewlines = firstNonBlank >= 0 ? firstNonBlank : lines.length === 0 ? -1 : lines.length;
            for (let idx = 0; idx < nPrefixNewlines; idx++) {
                yield cancel_1.default();
                nextBlock = block_1.getCurrentBlock();
                nextPrompt = prompt_1.getCurrentPrompt();
            }
            if (firstNonBlank >= 0) {
                nextPrompt.value = lines[firstNonBlank];
                if (lines.length - firstNonBlank > 1) {
                    const { doEval } = yield Promise.resolve().then(() => require('../repl/exec'));
                    yield doEval({ block: nextBlock, prompt: nextPrompt });
                    const remainingLines = lines.slice(firstNonBlank + 1).join('\n');
                    if (remainingLines.length > 0) {
                        paste_1.doPaste(remainingLines);
                    }
                }
            }
        }
    }
});
exports.pasteQueuedInput = (value) => {
    const invisibleHand = document.getElementById('invisible-global-input');
    invisibleHand.value = value;
};
//# sourceMappingURL=queueing.js.map