import { Tab } from './tab';
export declare type StripePosition = 'context' | 'meter' | 'button';
export declare type TextWithIcon = {
    icon: string;
    iconIsNarrow?: boolean;
    text: HTMLElement;
    onclick?: {
        icon?: string;
        text?: string;
    };
};
declare type FragmentTypes = TextWithIcon;
interface WithId {
    id: string;
}
export declare type Fragment = FragmentTypes & Partial<WithId>;
declare type ViewLevel = 'hidden' | 'normal' | 'obscured' | 'ok' | 'warn' | 'error';
declare type MyListener = (tab: Tab) => void;
declare type Listener<F extends Fragment> = (tab: Tab, hideable: StatusStripeController<F>, fragment: F) => void | Promise<void>;
export declare type StatusStripeContribution<F extends Fragment> = {
    fragment: F;
    listener: Listener<F>;
};
export interface StatusStripeController<F extends Fragment = TextWithIcon> {
    showAs(level: ViewLevel): StatusStripeController<F>;
    listen(cb: Listener<F>): Promise<MyListener>;
    unlisten(cb: MyListener): Promise<void>;
}
declare class StatusStripeAPI {
    private render;
    private wrap;
    addTo<F extends Fragment>(pos: StripePosition, fragment: F): StatusStripeController<F>;
    remove(pos: StripePosition, fragment: DocumentFragment | HTMLElement): void;
}
declare const _default: StatusStripeAPI;
export default _default;
