"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tabTagPattern = /^tab$/i;
function isTab(node) {
    return tabTagPattern.test(node.tagName);
}
exports.isTab = isTab;
function getTabId(tab) {
    return tab.getAttribute('data-tab-id');
}
exports.getTabId = getTabId;
exports.sameTab = (tab1, tab2) => {
    return getTabId(tab1) === getTabId(tab2);
};
exports.getTabFromTarget = (target) => {
    if (target) {
        let iter = target;
        while (iter && !isTab(iter)) {
            iter = iter.parentElement;
        }
        if (iter && isTab(iter)) {
            return iter;
        }
    }
    return document.querySelector('tab.visible');
};
exports.getCurrentTab = () => {
    return exports.getTabFromTarget(document.activeElement);
};
//# sourceMappingURL=tab.js.map