"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function polyfillGetUrlParameter(name) {
    name = name.replace(/[[]/, '\\[').replace(/[\]]/, '\\]');
    const regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
    const results = regex.exec(location.search);
    return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
}
exports.extractSearchKey = (key) => {
    if (typeof URLSearchParams === 'function') {
        return new URLSearchParams(window.location.search).get(key);
    }
    else {
        return polyfillGetUrlParameter(key);
    }
};
//# sourceMappingURL=search.js.map