"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const prettyPrintDuration = require("pretty-ms");
const execOptions_1 = require("../../models/execOptions");
function isDate(object) {
    return object && typeof object !== 'string' && typeof object !== 'number' && 'getMonth' in object;
}
const span = (text) => {
    const inner = document.createElement('span');
    inner.innerText = text;
    return inner;
};
exports.prettyPrintTime = (timestamp, fmt = 'long', previousTimestamp, execOptions = new execOptions_1.DefaultExecOptions()) => {
    const now = new Date();
    const then = !isDate(timestamp) ? new Date(timestamp) : timestamp;
    if (now.getFullYear() === then.getFullYear() && now.getMonth() === then.getMonth()) {
        const prev = previousTimestamp && (!isDate(previousTimestamp) ? new Date(previousTimestamp) : previousTimestamp);
        const prevOnSameDay = !!(prev &&
            (prev.getFullYear() === then.getFullYear() &&
                prev.getMonth() === then.getMonth() &&
                prev.getDate() === then.getDate()));
        const sameDay = () => {
            const delta = then.getTime() - prev.getTime();
            const verySmallDelta = Math.abs(delta) < 1000;
            if (fmt === 'delta' || verySmallDelta) {
                if (delta === 0) {
                    return span('');
                }
                else {
                    const sign = delta < 0 ? '' : '+';
                    return span(`${sign}${prettyPrintDuration(then.getTime() - prev.getTime())}`);
                }
            }
            else {
                const res = document.createElement('span');
                const prefix = document.createElement('span');
                prefix.classList.add('timestamp-same-day');
                prefix.innerText = '';
                res.appendChild(prefix);
                res.appendChild(document.createTextNode(then.toLocaleTimeString()));
                return res;
            }
        };
        if (now.getDate() === then.getDate()) {
            if (prevOnSameDay) {
                return sameDay();
            }
            else {
                return span(`Today at ${then.toLocaleTimeString()}`);
            }
        }
        else {
            if (prevOnSameDay) {
                return sameDay();
            }
            else {
                return span(then.toLocaleString(execOptions.language, {
                    weekday: fmt,
                    month: fmt,
                    day: 'numeric',
                    hour: 'numeric',
                    minute: 'numeric',
                    second: 'numeric'
                }));
            }
        }
    }
    else if (now.getFullYear() === then.getFullYear()) {
        return span(then.toLocaleString(execOptions.language, {
            weekday: fmt,
            month: fmt,
            day: 'numeric',
            hour: 'numeric',
            minute: 'numeric',
            second: 'numeric'
        }));
    }
    else {
        return span(then.toLocaleString());
    }
};
//# sourceMappingURL=time.js.map