"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('webapp/views/registrar/modes');
const registrar = [];
function registerSidecarMode(registration) {
    registrar.push(registration);
}
exports.registerSidecarMode = registerSidecarMode;
exports.default = registerSidecarMode;
exports.registerModeWhen = (when) => (mode) => {
    registerSidecarMode({ when, mode });
};
function apply(tab, modes, command, resource) {
    registrar
        .filter(({ when }) => {
        try {
            return when(resource.resource);
        }
        catch (err) {
            debug('warning: registered mode threw an exception during filter', err);
            return false;
        }
    })
        .forEach(({ mode }) => {
        const theModeOrButton = mode;
        const theMode = theModeOrButton;
        const idxOfPreexistingRegistrationForSameMode = modes.findIndex(({ mode }) => mode === theMode.mode);
        if (idxOfPreexistingRegistrationForSameMode < 0) {
            modes.push(theMode);
        }
        else {
            const oldMode = modes[idxOfPreexistingRegistrationForSameMode];
            const prio1 = oldMode.priority || 0;
            const prio2 = theMode.priority || 0;
            if (prio2 > prio1) {
                if (oldMode.defaultMode && theMode.defaultMode !== false) {
                    theMode.defaultMode = true;
                }
                modes.splice(idxOfPreexistingRegistrationForSameMode, 1, theMode);
            }
        }
    });
}
exports.apply = apply;
//# sourceMappingURL=modes.js.map