import { ParsedOptions } from '../command';
import { Tab } from '../../webapp/tab';
import { MetadataBearing } from '../entity';
import { CustomSpec } from '../../webapp/views/sidecar-core';
import { Table } from '../../webapp/models/table';
import { MultiModalResponse } from './types';
import { Content, ScalarResource } from './content-types';
declare type TabPresentableContent = CustomSpec | HTMLElement | Table;
/**
 * Turn a Resource into content that can be presented in a sidecar tab
 *
 */
export declare function formatForTab<T extends MetadataBearing>(tab: Tab, mmr: T, resource: ScalarResource | Content<T>, args: {
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
}): Promise<TabPresentableContent>;
/**
 * Render a MultiModalResponse to the sidecar
 *
 */
export declare function show<T extends MetadataBearing>(tab: Tab, mmr: MultiModalResponse<T>, args: {
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
}): Promise<import("../../webapp/views/presentation").default>;
export {};
