import { WatchableJob } from '../core/jobs/job';
/**
 * State that we want to keep per tab
 *
 */
export default class TabState {
    /** is the tab closed? */
    closed: boolean;
    /** environment variables */
    private _env;
    /** current working directory */
    private _cwd;
    /** jobs attached to this tab */
    private _jobs;
    private _age;
    private _ageCounter;
    private _currentBottomInputValue;
    /** is there a drilldown in progress for this tab? */
    drilldownInProgress: Promise<void>;
    get env(): Record<string, string>;
    get cwd(): string;
    get currentBottomInputValue(): string;
    capture(): void;
    /**
     * @return the number of attached jobs
     */
    get jobs(): number;
    /** INTERNAL: abort the oldest job, and return the index of its slot */
    private abortOldestJob;
    /** INTERNAL: find a free job slot, aborting the oldest job if necessary to free up a slot */
    private findFreeJobSlot;
    /** attach a job to this tab */
    captureJob(job: WatchableJob): void;
    /**
     * Abort all jobs attached to this tab
     *
     */
    abortAllJobs(): void;
    /** INTERNAL: abort the job at the given index */
    private abortAt;
    /** INTERNAL: clear the references to the job at the given index */
    private clearAt;
    /**
     * Restore tab state
     *
     */
    restore(): void;
}
