import { PrescanModel } from './prescan';
import { KuiPlugin } from '../models/plugin';
export declare const pluginRoot = "../../../../plugins";
/**
 * This is the registrar for plugins used at runtime (i.e. "live, not
 * scanning"). This is not related to the prescan computation.
 *
 */
export declare const registrar: Record<string, KuiPlugin>;
export declare function prescanModel(): PrescanModel;
/**
 * For internal use only: set the prescan model
 *
 */
export declare function _useUpdatedUserPrescan(userPrescan: PrescanModel): void;
export declare const preload: () => void;
/**
 * @return the home directory for user-installed plugins. All
 * artifacts related to user-installed plugins will be stored within
 * this directory.
 *
 */
export declare function userInstalledHome(): Promise<string>;
/**
 * Load the prescan model, in preparation for loading the shell
 *
 * @return truthy value if we indeed did the initialization
 */
export declare const init: () => Promise<boolean>;
