import { Executor, ReplEval } from './types';
import { EvaluatorArgs } from '../models/command';
import REPL from '../models/repl';
import { RawResponse, MixedResponse } from '../models/entity';
import { ExecOptions } from '../models/execOptions';
import { CodedError } from '../models/errors';
import { UsageModel } from '../core/usage-error';
import { Tab } from '../webapp/tab';
export declare const setEvaluatorImpl: (impl: ReplEval) => void;
/**
 * How to handle errors in command execution? Headless might want to
 * override the graphical default
 *
 */
declare type OopsHandler = (block: HTMLElement, nextBlock: HTMLElement) => (err: Error) => void;
export declare const installOopsHandler: (fn: OopsHandler) => void;
export declare const exec: (commandUntrimmed: string, execOptions?: ExecOptions) => Promise<string | number | boolean | HTMLElement | import("../models/entity").MessageBearingEntity | Error | import("../models/entity").ResourceModification | import("../webapp/views/sidecar-core").CustomSpec<void> | MixedResponse | import("..").MultiModalResponse<import("../models/entity").MetadataBearing<void>> | import("../models/entity").LowLevelLoop | UsageModel | import("..").Table<import("..").Row> | import("../models/entity").MetadataBearing<any> | RawResponse<any> | CodedError<number>>;
/**
 * User hit enter in the REPL
 *
 */
export declare const doEval: ({ block, prompt }?: {
    block?: import("../webapp/models/block").Block;
    prompt?: import("../webapp/prompt").Prompt;
}) => Promise<string | number | boolean | HTMLElement | import("../models/entity").MessageBearingEntity | Error | import("../models/entity").ResourceModification | import("../webapp/views/sidecar-core").CustomSpec<void> | MixedResponse | import("..").MultiModalResponse<import("../models/entity").MetadataBearing<void>> | import("../models/entity").LowLevelLoop | UsageModel | import("..").Table<import("..").Row> | import("../models/entity").MetadataBearing<any> | RawResponse<any> | CodedError<number>>;
/**
 * If, while evaluating a command, it needs to evaluate a sub-command...
 *
 */
export declare const qexec: <T extends import("../models/entity").Entity<any, import("..").Row, import("../models/entity").MetadataBearing<any>>>(command: string, block?: boolean | HTMLElement, contextChangeOK?: boolean, execOptions?: ExecOptions, nextBlock?: HTMLElement) => Promise<T>;
export declare const qfexec: (command: string, block?: HTMLElement, nextBlock?: HTMLElement, execOptions?: ExecOptions) => Promise<any>;
/**
 * "raw" exec, where we want the data model back directly
 *
 */
export declare const rexec: <Raw extends any>(command: string, execOptions?: ExecOptions) => Promise<RawResponse<Raw>>;
/**
 * Programmatic exec, as opposed to human typing and hitting enter
 *
 */
export declare const pexec: <T extends import("../models/entity").Entity<any, import("..").Row, import("../models/entity").MetadataBearing<any>>>(command: string, execOptions?: ExecOptions) => Promise<T>;
/**
 * Execute a command in response to an in-view click
 *
 */
export declare const click: (command: string | (() => Promise<string>), evt: MouseEvent) => Promise<void>;
/**
 * Update the executor impl
 *
 */
export declare const setExecutorImpl: (impl: Executor) => void;
/**
 * If the command is semicolon-separated, invoke each element of the
 * split separately
 *
 */
export declare function semicolonInvoke(opts: EvaluatorArgs): Promise<MixedResponse>;
/**
 * @return an instance that obeys the REPL interface
 *
 */
export declare function getImpl(tab: Tab): REPL;
export {};
