/// <reference types="node" />
interface ScrollOptions {
    when?: number;
    which?: string;
    element?: HTMLElement;
    how?: 'scrollIntoViewIfNeeded' | 'scrollIntoView';
    center?: boolean | ScrollIntoViewOptions;
}
/**
 * Make sure that the given repl block is visible.
 *
 * @param when wait this long; e.g. the 305ms is in step with the sidecar transition: all 300ms ease-in-out
 * @param which the repl block sub-element that needs to be visible
 * @param element the element to scroll into view (optional, defaults to use @which)
 * @param center this is passed directly to the underlying API https://developer.mozilla.org/en-US/docs/Web/API/Element/scrollIntoViewIfNeeded
 *
 */
export declare const scrollIntoView: (opts?: ScrollOptions) => NodeJS.Timeout;
export {};
