import { Tab } from './tab';
export declare type StripePosition = 'context' | 'meter' | 'button';
/**
 * The `icon` is assumed to be html represented as text.
 *
 */
export declare type TextWithIcon = {
    /** The `icon` is assumed to be html represented as text */
    icon: string;
    /** for narrower icons */
    iconIsNarrow?: boolean;
    /** The `text` is an HTML element */
    text: HTMLElement;
    /** The onclick handlers, interpted as command lines to be executed */
    onclick?: {
        icon?: string;
        text?: string;
    };
};
/** Supported impls of Fragment */
declare type FragmentTypes = TextWithIcon;
interface WithId {
    /** An identifier that can be helpful with testing */
    id: string;
}
export declare type Fragment = FragmentTypes & Partial<WithId>;
/** variants of how the information should ber presented */
declare type ViewLevel = 'hidden' | 'normal' | 'obscured' | 'ok' | 'warn' | 'error';
/** event listener, e.g. new type, switch tab */
declare type MyListener = (tab: Tab) => void;
declare type Listener<F extends Fragment> = (tab: Tab, hideable: StatusStripeController<F>, fragment: F) => void | Promise<void>;
/** a `Contribution` is a UI `Fragment` along with an event `Listener` */
export declare type StatusStripeContribution<F extends Fragment> = {
    fragment: F;
    listener: Listener<F>;
};
export interface StatusStripeController<F extends Fragment = TextWithIcon> {
    /**
     * Change the ViewLevel of the fragment
     *
     * @return this controller
     */
    showAs(level: ViewLevel): StatusStripeController<F>;
    listen(cb: Listener<F>): Promise<MyListener>;
    unlisten(cb: MyListener): Promise<void>;
}
/**
 * The StatusStripe API.
 *
 */
declare class StatusStripeAPI {
    private render;
    private wrap;
    /**
     * Append the given `fragment` at the given position `pos`. Note:
     * that the fragment will be hidden by default. This is to avoid the
     * fragment showing in a partial form prior to the first
     * availability of data.
     *
     * @return a controller that can be used e.g. to change whether or
     * not the fragment is visible
     *
     */
    addTo<F extends Fragment>(pos: StripePosition, fragment: F): StatusStripeController<F>;
    remove(pos: StripePosition, fragment: DocumentFragment | HTMLElement): void;
}
declare const _default: StatusStripeAPI;
/**
 * Export the API impl
 *
 */
export default _default;
