import { WebContents } from 'electron';
/**
 * Return the previously selected (and persisted) choice of theme
 *
 */
export declare const getPersistedThemeChoice: () => Promise<string>;
/**
 * Internal logic to switch themes
 *
 */
export declare const switchTo: (theme: string, webContents?: WebContents, saveNotNeeded?: boolean) => Promise<void>;
/**
 * Switch to the last user choice, if the user so indicated
 *
 */
export declare const switchToPersistedThemeChoice: (webContents?: WebContents, isDarkMode?: boolean) => Promise<void>;
/**
 * Reset to the default theme
 *
 */
export declare const resetToDefault: () => Promise<boolean>;
