/**
 * Sidecar badges
 *
 */
import { Tab } from '../tab';
import { Sidecar } from './sidecar-core';
/**
 * Return the DOM elements housing the sidecar badges
 *
 */
export declare function getBadgesDomContainer(sidecar: Sidecar): {
    badgesDomContainer: Element;
    badgesDom: HTMLElement;
};
/**
 * This is the most complete form of a badge specification, allowing
 * the caller to provide a title, an onclick handler, and an optional
 * fontawesome icon representation.
 *
 */
export interface BadgeSpec {
    title: string;
    fontawesome?: string;
    image?: HTMLImageElement | SVGElement;
    css?: string;
    onclick?: (evt: MouseEvent) => boolean;
}
export declare type Badge = string | BadgeSpec | Element;
export interface BadgeOptions {
    css?: string;
    onclick?: () => void;
    badgesDom: Element;
}
export declare class DefaultBadgeOptions implements BadgeOptions {
    readonly badgesDom: HTMLElement;
    constructor(tab: Tab);
}
export declare const addBadge: (tab: Tab, badgeText: Badge, { css, onclick, badgesDom }?: BadgeOptions) => HTMLElement;
export declare const clearBadges: (tab: Tab) => void;
export declare function hasBadge(tab: Tab, cls: string): boolean;
