/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import Debug from 'debug';
import { addBadge } from '../badge';
const debug = Debug('webapp/views/registrar/badges');
/** registered badge handlers */
const registrar = [];
/**
 * Register a new badge
 *
 */
export function registerSidecarBadge(registration) {
    registrar.push(registration);
}
export default registerSidecarBadge;
/**
 * Add all registered badges that are relevant to the given resource
 *
 */
export function apply(tab, entity, badgeOptions) {
    registrar
        .filter(({ when }) => {
        // filter out any irrelevant badges (for this resource)
        try {
            return when(entity.resource);
        }
        catch (err) {
            debug('warning: registered badge threw an exception during filter', err);
            return false;
        }
    })
        .forEach(({ badge }) => {
        // now add the badge
        if (typeof badge === 'function') {
            addBadge(tab, badge(entity.resource, tab), badgeOptions);
        }
        else {
            addBadge(tab, badge, badgeOptions);
        }
    });
}
//# sourceMappingURL=badges.js.map