"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('plugins/bash-like/util/sidecar-support');
exports.asSidecarContent = (renderedContent, tag = 'pre') => {
    const content = document.createElement('div');
    content.classList.add('code-highlighting');
    content.classList.add('scrollable');
    content.classList.add('scrollable-auto');
    const scrollInner = document.createElement(tag);
    scrollInner.classList.add('padding-content');
    content.appendChild(scrollInner);
    if (typeof renderedContent === 'string') {
        scrollInner.innerHTML = renderedContent;
    }
    else {
        scrollInner.appendChild(renderedContent);
    }
    return content;
};
exports.asSidecarEntity = (cmdLine, renderedContent, options = {}, tag = 'pre', prettyType = 'shell', subtext) => {
    debug('asSidecarEntity', options);
    return Object.assign({
        type: 'custom',
        prettyType,
        isEntity: true,
        subtext,
        name: cmdLine,
        content: exports.asSidecarContent(renderedContent, tag)
    }, options);
};
//# sourceMappingURL=sidecar-support.js.map