"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const EventEmitter = require("events");
const server_1 = require("./server");
const debug = debug_1.default('plugins/bash-like/pty/channel');
var ReadyState;
(function (ReadyState) {
    ReadyState[ReadyState["CONNECTING"] = 0] = "CONNECTING";
    ReadyState[ReadyState["OPEN"] = 1] = "OPEN";
    ReadyState[ReadyState["CLOSING"] = 2] = "CLOSING";
    ReadyState[ReadyState["CLOSED"] = 3] = "CLOSED";
})(ReadyState = exports.ReadyState || (exports.ReadyState = {}));
class InProcessChannel extends EventEmitter {
    constructor(otherSide) {
        super();
        this.readyState = ReadyState.OPEN;
        if (otherSide) {
            this.otherSide = otherSide;
        }
        else {
            this.otherSide = new InProcessChannel(this);
        }
    }
    init() {
        return __awaiter(this, void 0, void 0, function* () {
            debug('IPC init');
            yield server_1.onConnection(yield server_1.disableBashSessions())(this.otherSide);
            this.emit('open');
            debug('IPC init done');
        });
    }
    close() {
    }
    send(msg) {
        if (this.otherSide.readyState === ReadyState.OPEN) {
            try {
                this.otherSide.emit('message', msg);
            }
            catch (err) {
                console.error(err);
            }
        }
    }
    removeEventListener(eventType, handler) {
        this.off(eventType, handler);
    }
}
exports.InProcessChannel = InProcessChannel;
class WebViewChannelRendererSide extends EventEmitter {
    constructor() {
        super(...arguments);
        this.readyState = ReadyState.OPEN;
    }
    init() {
        return __awaiter(this, void 0, void 0, function* () {
            debug('IPC init');
            const { body } = yield window['webview-proxy']({
                command: 'init',
                provider: 'pty',
                channel: this
            });
            this.channelId = body.channelId;
            console.log(`CHANNELID ${this.channelId}`);
            this.emit('open');
            debug('IPC init done');
        });
    }
    close() {
        this.emit('exit');
    }
    send(body) {
        console.log(`SEND ${this.channelId}`);
        window['webview-proxy']({
            command: 'send',
            provider: 'pty',
            channelId: this.channelId,
            body
        });
    }
    removeEventListener(eventType, handler) {
        this.off(eventType, handler);
    }
}
exports.WebViewChannelRendererSide = WebViewChannelRendererSide;
//# sourceMappingURL=channel.js.map