"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('plugins/bash-like/pty/prefetch');
debug('loading');
const child_process_1 = require("child_process");
const propertiesParser = require("properties-parser");
function prefetchEnv() {
    return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
        if (process.env.TERM || process.platform === 'win32') {
            debug('skipping prefetchEnv');
            return resolve();
        }
        debug('prefetchEnv');
        const { getLoginShell } = yield Promise.resolve().then(() => require('./server'));
        const { shellExe: shell } = yield getLoginShell();
        debug('prefetchEnv got shell', shell);
        child_process_1.exec(`${shell} -l -c printenv`, (err, stdout, stderr) => {
            try {
                if (stderr) {
                    debug(stderr);
                }
                if (err) {
                    debug('error in prefetchEnv 1', err);
                    reject(err);
                }
                else {
                    const env = propertiesParser.parse(stdout.toString());
                    debug('got env', env);
                    for (const key in env) {
                        if (key !== '_') {
                            process.env[key] = env[key];
                        }
                    }
                    resolve();
                }
            }
            catch (err) {
                console.error('error in prefetchEnv 2', err);
                reject(err);
            }
        });
    }));
}
function prefetchHome() {
    return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
        if (process.env.HOME) {
            debug('skipping prefetchHome');
            return resolve();
        }
        child_process_1.exec('eval echo ~', (err, stdout, stderr) => {
            try {
                if (stderr) {
                    debug(stderr);
                }
                if (err) {
                    debug('Error retrieving HOME', err);
                }
                else {
                    const HOME = stdout.toString();
                    debug('got HOME', HOME);
                    process.env._HOME = HOME;
                }
            }
            catch (err) {
                reject(err);
            }
            finally {
                resolve();
            }
        });
    }));
}
exports.default = () => Promise.all([prefetchEnv(), prefetchHome()])
    .then(() => {
    if (process.env._HOME && !process.env.HOME) {
        process.env.HOME = process.env._HOME;
        delete process.env._HOME;
    }
})
    .catch(err => {
    console.error('error prefetching state', err);
});
//# sourceMappingURL=prefetch.js.map