"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const os_1 = require("os");
const fs_1 = require("fs");
const core_1 = require("@kui-shell/core");
const strings = core_1.i18n('plugin-bash-like');
function formatPermissions(stats, isFile, isDirectory, isSymbolicLink) {
    const { mode } = stats;
    const d = isDirectory ? 'd' : isSymbolicLink ? 'l' : isFile ? '-' : 's';
    const ur = mode & fs_1.constants.S_IRUSR ? 'r' : '-';
    const uw = mode & fs_1.constants.S_IWUSR ? 'w' : '-';
    const ux = mode & fs_1.constants.S_IXUSR ? 'x' : '-';
    const gr = mode & fs_1.constants.S_IRGRP ? 'r' : '-';
    const gw = mode & fs_1.constants.S_IWGRP ? 'w' : '-';
    const gx = mode & fs_1.constants.S_IXGRP ? 'x' : '-';
    const or = mode & fs_1.constants.S_IROTH ? 'r' : '-';
    const ow = mode & fs_1.constants.S_IWOTH ? 'w' : '-';
    const ox = mode & fs_1.constants.S_IXOTH ? 'x' : '-';
    return `${d}${ur}${uw}${ux}${gr}${gw}${gx}${or}${ow}${ox}`;
}
function isDir(filepath) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            fs_1.stat(filepath, (err, stats) => {
                if (err) {
                    if (err.code === 'ENOENT') {
                        resolve(undefined);
                    }
                    else {
                        reject(err);
                    }
                }
                else {
                    resolve(stats);
                }
            });
        });
    });
}
const nope = () => false;
const yup = () => true;
function kuiglob({ tab, argvNoOptions, parsedOptions }) {
    return __awaiter(this, void 0, void 0, function* () {
        const globby = require('globby');
        const inputs = argvNoOptions
            .slice(argvNoOptions.indexOf('kuiglob') + 1)
            .map(core_1.expandHomeDir)
            .map(_ => _.replace(/([^\\])"/g, '$1'));
        const stats = inputs.length === 0 ? [] : yield Promise.all(inputs.map(isDir));
        const startingPointsAreDirs = stats.map(_ => _ && _.isDirectory());
        const toGlob = inputs
            .filter((_, idx) => !parsedOptions.d || !startingPointsAreDirs[idx])
            .reduce((A, _, idx) => {
            if (!parsedOptions.d) {
                if (startingPointsAreDirs[idx]) {
                    A.push(_.endsWith('/') ? `${_}*` : `${_}/*`);
                    return A;
                }
                else if (_.endsWith('*')) {
                    A.push(_);
                    A.push(`${_}/*`);
                    return A;
                }
            }
            A.push(_);
            return A;
        }, []);
        const needStats = parsedOptions.l || parsedOptions.C;
        const globbedEntries = toGlob.length === 0 && inputs.length > 0
            ? []
            : (yield globby(toGlob.length === 0 ? '*' : toGlob, {
                followSymbolicLinks: false,
                onlyFiles: false,
                dot: parsedOptions.a || parsedOptions.all,
                stats: needStats,
                objectMode: !needStats,
                cwd: core_1.isHeadless() ? process.cwd() : tab.state.cwd
            }));
        const dirEntries = !parsedOptions.d
            ? []
            : inputs
                .map((name, idx) => {
                if (!startingPointsAreDirs[idx]) {
                    return undefined;
                }
                else {
                    return {
                        name,
                        path: name,
                        dirent: {
                            isFile: nope,
                            isSymbolicLink: nope,
                            isDirectory: yup
                        },
                        stats: stats[idx]
                    };
                }
            })
                .filter(_ => _);
        const entries = globbedEntries.concat(dirEntries);
        if (entries.length === 0 && !inputs.some(_ => /\*/.test(_)) && !startingPointsAreDirs.some(_ => _)) {
            const error = new Error(strings('No such file or directory'));
            error.code = 404;
            throw error;
        }
        const user = os_1.userInfo();
        return {
            mode: 'raw',
            content: entries.map(({ name, path, dirent, stats }) => {
                const isFile = dirent.isFile();
                const isDirectory = dirent.isDirectory();
                const isSymbolicLink = dirent.isSymbolicLink();
                const isExecutable = stats && !!(stats.mode & (fs_1.constants.S_IXUSR | fs_1.constants.S_IXGRP | fs_1.constants.S_IXOTH));
                const isSpecial = !isFile && !isDirectory && !isSymbolicLink;
                const nameForDisplay = toGlob.length > 1 ? path : name;
                return {
                    name,
                    path,
                    nameForDisplay,
                    stats,
                    dirent: {
                        isFile,
                        isDirectory,
                        isSymbolicLink,
                        isExecutable,
                        isSpecial,
                        permissions: parsedOptions.l ? formatPermissions(stats, isFile, isDirectory, isSymbolicLink) : '',
                        username: stats && user.uid === stats.uid ? user.username : ''
                    }
                };
            })
        };
    });
}
exports.default = (commandTree) => {
    commandTree.listen('/kuiglob', kuiglob, {
        hidden: true,
        requiresLocal: true,
        flags: {
            boolean: ['a', 'all', 'd', 'l', 'C']
        }
    });
};
//# sourceMappingURL=glob.js.map