"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const path_1 = require("path");
const core_1 = require("@kui-shell/core");
const tab_completion_1 = require("@kui-shell/plugin-core-support/tab-completion");
function completeLocalFiles(tab, commandLine, { toBeCompleted }) {
    return __awaiter(this, void 0, void 0, function* () {
        return (yield tab.REPL.rexec(`fscomplete ${toBeCompleted}`)).content;
    });
}
function doComplete(args) {
    const last = args.command.substring(args.command.indexOf('fscomplete ') + 'fscomplete '.length);
    const lastIsDir = last.charAt(last.length - 1) === '/';
    const dirname = lastIsDir ? last : path_1.dirname(last);
    if (dirname) {
        return new Promise((resolve, reject) => {
            const dirToScan = core_1.expandHomeDir(dirname);
            fs_1.readdir(dirToScan, (err, files) => __awaiter(this, void 0, void 0, function* () {
                if (err) {
                    console.error('fs.readdir error', err);
                    reject(err);
                }
                else {
                    const partial = tab_completion_1.shellescape(path_1.basename(last) + (lastIsDir ? '/' : ''));
                    const partialHasADot = partial.startsWith('.');
                    const matches = files.filter(_f => {
                        const f = tab_completion_1.shellescape(_f);
                        return ((lastIsDir || f.indexOf(partial) === 0) &&
                            !f.endsWith('~') &&
                            f !== '.' &&
                            f !== '..' &&
                            (partialHasADot || !f.startsWith('.')));
                    });
                    resolve({
                        mode: 'raw',
                        content: yield Promise.all(matches.map((match) => __awaiter(this, void 0, void 0, function* () {
                            const completion = lastIsDir ? match : match.substring(partial.length);
                            if (yield tab_completion_1.isDirectory(path_1.join(dirToScan, match))) {
                                return `${completion}/`;
                            }
                            else {
                                return { completion, addSpace: true };
                            }
                        })))
                    });
                }
            }));
        });
    }
}
function preload() {
    tab_completion_1.registerTabCompletionEnumerator(completeLocalFiles);
}
exports.preload = preload;
function plugin(registrar) {
    registrar.listen('/fscomplete', doComplete, { hidden: true, requiresLocal: true });
}
exports.plugin = plugin;
//# sourceMappingURL=tab-completion.js.map