import { Registrar, Tab } from '@kui-shell/core';
import { Channel } from './channel';
/**
 * Return the cached websocket for the given tab
 *
 */
export declare function getChannelForTab(tab: Tab): Channel;
/**
 * Return the session for the given tab
 *
 */
export declare function getSessionForTab(tab: Tab): Promise<Channel>;
/**
 * Keep trying until we can establish a session
 *
 */
export declare function pollUntilOnline(tab: Tab, block?: HTMLElement): Promise<unknown>;
export declare function registerCommands(commandTree: Registrar): void;
/**
 * Initialize per-tab websocket session management
 *
 */
export declare function init(): Promise<void>;
