"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const debug = debug_1.default('plugins/core-support/clear');
const usage = {
    command: 'clear',
    strict: 'clear',
    example: 'clear',
    docs: 'Clear the console',
    optional: [{ name: '--keep-current-active', alias: '-k', boolean: true, hidden: true }]
};
const clear = ({ parsedOptions, tab }) => {
    if (!core_1.isHeadless()) {
        if (!parsedOptions.k) {
            debug('clearing everything, the repl loop will set up the next prompt for us');
            core_1.empty(tab.querySelector('.repl-inner'));
            const tabState = tab.state;
            tabState.abortAllJobs();
        }
        else {
            debug('preserving the current active prompt');
            const selector = '.repl-inner .repl-block:not(.repl-active):not(.processing)';
            const blocks = tab.querySelectorAll(selector);
            for (let idx = 0; idx < blocks.length; idx++) {
                blocks[idx].parentNode.removeChild(blocks[idx]);
            }
            const remainingBlock = tab.querySelector('.repl-block');
            core_1.resetCount(remainingBlock);
            const processing = '.repl-inner .repl-block.processing';
            return tab.querySelector(processing) || true;
        }
    }
    core_1.closeAllViews(tab);
    return true;
};
exports.default = (commandTree) => {
    commandTree.listen('/clear', clear, {
        usage,
        noAuthOk: true,
        inBrowserOk: true
    });
};
//# sourceMappingURL=clear.js.map