"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const debug = debug_1.default('core-support/history/reverse-i-search');
const strings = {
    prompt: "(reverse-i-search$1)`$2': "
};
class ActiveISearch {
    constructor(tab) {
        this.isSearchActive = true;
        this.currentSearchIdx = -1;
        this.tab = tab;
        this.prompt = core_1.getCurrentPrompt(tab);
        this.promptLeft = core_1.getCurrentPromptLeft(tab);
        this.placeholder = document.createElement('span');
        this.placeholderFixedPart = document.createElement('span');
        this.placeholderFixedPart.innerText = strings.prompt.replace(/\$1/, '').replace(/\$2/, this.prompt.value);
        this.placeholder.appendChild(this.placeholderFixedPart);
        this.placeholder.classList.add('repl-temporary');
        this.placeholder.classList.add('normal-text');
        this.placeholder.classList.add('monospace');
        this.placeholderFixedPart.classList.add('smaller-text');
        this.placeholderFixedPart.classList.add('small-right-pad');
        this.promptLeft.appendChild(this.placeholder);
        core_1.setUsingCustomPrompt(core_1.getBlockOfPrompt(this.prompt));
        this.placeholderContentPart = document.createElement('span');
        this.placeholderTypedPart = document.createElement('strong');
        this.placeholderMatchedPrefixPart = document.createElement('span');
        this.placeholderMatchedSuffixPart = document.createElement('span');
        this.placeholderContentPart.appendChild(this.placeholderMatchedPrefixPart);
        this.placeholderContentPart.appendChild(this.placeholderTypedPart);
        this.placeholderContentPart.appendChild(this.placeholderMatchedSuffixPart);
        this.placeholderContentPart.classList.add('repl-input-like');
        this.placeholder.appendChild(this.placeholderContentPart);
        this.placeholderTypedPart.classList.add('red-text');
        this.placeholderTypedPart.classList.add('kui--prompt-like');
        this.placeholderMatchedPrefixPart.classList.add('slightly-deemphasize');
        this.placeholderMatchedSuffixPart.classList.add('slightly-deemphasize');
        this.currentOnInput = this.prompt.oninput;
        this.prompt.oninput = this.doSearch.bind(this);
        this.currentOnKeypress = this.prompt.onkeypress;
        this.prompt.onkeypress = this.maybeComplete.bind(this);
    }
    cancelISearch(evt) {
        const isCtrlC = evt && evt.keyCode === core_1.KeyCodes.C && evt.ctrlKey;
        this.tab['_kui_active_i_search'] = undefined;
        if (this.isSearchActive) {
            this.isSearchActive = false;
            if (!isCtrlC || core_1.inBottomInputMode) {
                core_1.unsetUsingCustomPrompt(core_1.getBlockOfPrompt(this.prompt));
                if (this.placeholder.parentNode) {
                    this.placeholder.parentNode.removeChild(this.placeholder);
                }
                this.prompt.onkeypress = this.currentOnKeypress;
                this.prompt.oninput = this.currentOnInput;
                this.prompt.focus();
            }
        }
    }
    doSearch(evt) {
        return __awaiter(this, void 0, void 0, function* () {
            debug('doSearch', evt);
            if (evt.inputType === 'deleteContentBackward') {
                this.currentSearchIdx = -1;
                this.placeholderFixedPart.innerText = strings.prompt.replace(/\$1/, ``).replace(/\$2/, this.prompt.value);
            }
            const userHitCtrlR = evt.ctrlKey && evt.code === 'KeyR';
            const startIdx = userHitCtrlR ? this.currentSearchIdx - 1 : -1;
            const history = yield core_1.History(this.tab);
            const newSearchIdx = this.prompt.value && history.findIndex(this.prompt.value, startIdx);
            debug('search index', this.prompt.value, newSearchIdx);
            if (newSearchIdx > 0) {
                this.currentSearchIdx = newSearchIdx;
                this.placeholderFixedPart.innerText = strings.prompt
                    .replace(/\$1/, '')
                    .replace(/\$2/, this.prompt.value);
                const newValue = history.line(this.currentSearchIdx).raw;
                debug('newValue', newValue);
                const caretPosition = newValue.indexOf(this.prompt.value) + 1;
                debug('caretPosition', caretPosition);
                const matchedPrefix = newValue.substring(0, caretPosition - 1);
                const matchedSuffix = newValue.substring(caretPosition + this.prompt.value.length - 1);
                debug('matchedPrefix', matchedPrefix, newValue, caretPosition);
                debug('matchedSuffix', matchedSuffix);
                this.placeholderTypedPart.innerText = this.prompt.value.replace(/ /g, '_');
                this.placeholderMatchedPrefixPart.innerText = matchedPrefix;
                this.placeholderMatchedSuffixPart.innerText = matchedSuffix;
                this.placeholderContentPart.setAttribute('data-full-match', newValue);
            }
            else if (!userHitCtrlR) {
                this.placeholderTypedPart.innerText = '';
                this.placeholderMatchedPrefixPart.innerText = '';
                this.placeholderMatchedSuffixPart.innerText = '';
                this.placeholderFixedPart.innerText = strings.prompt.replace(/\$1/, ``).replace(/\$2/, this.prompt.value);
            }
            else {
                this.placeholderFixedPart.classList.add('alert-pulse');
                setTimeout(() => this.placeholderFixedPart.classList.remove('alert-pulse'), 1000);
            }
        });
    }
    completeSearch() {
        debug('completing search');
        this.prompt.value = this.placeholderContentPart.getAttribute('data-full-match');
        this.cancelISearch();
    }
    maybeComplete(evt) {
        if (this.isSearchActive) {
            if (evt.keyCode === core_1.KeyCodes.ENTER) {
                this.completeSearch();
                this.prompt.dispatchEvent(new KeyboardEvent(evt.type, evt));
            }
        }
    }
}
function registerListener() {
    if (typeof document === 'undefined') {
        return;
    }
    if (core_1.inBottomInputMode) {
        core_1.eventBus.on('/core/cli/install-block', (tab) => {
            const activeSearch = tab['_kui_active_i_search'];
            if (activeSearch) {
                activeSearch.cancelISearch();
            }
        });
    }
    document.getElementsByTagName('body')[0].addEventListener('keyup', (evt) => {
        if (!document.activeElement.classList.contains('repl-input-element')) {
        }
        else if (evt.ctrlKey &&
            (process.platform === 'darwin' ||
                /Macintosh/.test(navigator.userAgent) ||
                (!core_1.inBrowser() && !process.env.RUNNING_SHELL_TEST) ||
                evt.metaKey)) {
            const tab = core_1.getTabFromTarget(evt.srcElement);
            const activeSearch = tab['_kui_active_i_search'];
            if (evt.keyCode === core_1.KeyCodes.R) {
                debug('got ctrl+r');
                if (activeSearch) {
                    debug('continuation of existing reverse-i-search');
                    activeSearch.doSearch(evt);
                }
                else {
                    debug('new reverse-i-search');
                    tab['_kui_active_i_search'] = new ActiveISearch(tab);
                }
            }
            else if (activeSearch && core_1.isCursorMovement(evt)) {
                activeSearch.completeSearch();
            }
            else if (activeSearch) {
                debug('cancel', evt.keyCode);
                activeSearch.cancelISearch(evt);
            }
        }
    });
}
exports.default = () => {
    try {
        registerListener();
    }
    catch (err) {
        debug('Not running in electron environment');
    }
};
//# sourceMappingURL=reverse-i-search.js.map