"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const usage = {
    command: 'shell',
    title: 'Visual Shell',
    header: 'Open the visual shell',
    headlessOnly: true
};
const docs = {
    usage,
    needsUI: true,
    fullscreen: false,
    noEcho: true,
    noHistory: true,
    noAuthOk: true
};
exports.default = (commandTree) => {
    const doIt = () => ({ execOptions }) => {
        if (!core_1.isHeadless() && (!execOptions || !execOptions.causedByHeadless)) {
            throw new Error(`Usage: This command is intended for use from the CLI, to launch this graphical Shell.
You are already here. Welcome!`);
        }
        return true;
    };
    commandTree.listen(`/shell`, doIt(), docs);
};
//# sourceMappingURL=open-ui-from-terminal.js.map