"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const keys = {
    ZOOM_RESET: 48,
    ZOOM_IN: 187,
    ZOOM_OUT: 189
};
const usage = {
    get: {
        command: 'get',
        strict: 'get',
        docs: 'Get the current font zoom level'
    },
    reset: {
        command: 'reset',
        strict: 'reset',
        docs: 'Reset the current font zoom level to the default'
    },
    set: {
        command: 'set',
        strict: 'set',
        docs: 'Set the current font zoom level',
        required: [
            {
                name: 'level',
                numeric: true,
                docs: 'A zoom level',
                allowed: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0, -1, -2],
                defaultValue: 1
            }
        ]
    }
};
function injectContent() {
    if (!document.querySelector('#kui-zoom-overlay')) {
        setTimeout(() => __awaiter(this, void 0, void 0, function* () {
            const { injectCSS } = yield Promise.resolve().then(() => require('@kui-shell/core'));
            injectCSS({
                css: require('@kui-shell/plugin-core-support/web/css/zoom.css').toString(),
                key: 'zoom.css'
            });
        }), 0);
        const overlay = document.createElement('div');
        overlay.className = 'zoom-overlay hidden';
        overlay.id = 'kui-zoom-overlay';
        document.body.appendChild(overlay);
    }
}
const _set = newZoom => {
    const main = document.querySelector('body > .page');
    if (newZoom <= 10 && newZoom >= -2) {
        main.setAttribute('data-zoom', newZoom);
    }
    else {
        throw new core_1.UsageError({
            message: 'Unsupported zoom level',
            usage: usage.set
        });
    }
    const editors = document.querySelectorAll('.monaco-editor-wrapper');
    for (let idx = 0; idx < editors.length; idx++) {
        const editor = editors[idx]['editor'];
        if (editor) {
            if (editor && editor.updateOptions) {
                const delta = editors[idx]['baseFontSize'] * 0.0625 * newZoom;
                const newFontSize = editors[idx]['baseFontSize'] + delta;
                editor.updateOptions({ fontSize: newFontSize });
            }
        }
    }
    return true;
};
function set({ argvNoOptions }) {
    return __awaiter(this, void 0, void 0, function* () {
        yield injectContent();
        const newZoom = argvNoOptions[argvNoOptions.indexOf('set') + 1];
        return _set(newZoom);
    });
}
const reset = () => _set(1);
const listener = (event) => __awaiter(void 0, void 0, void 0, function* () {
    const char = event.keyCode;
    if (event.shiftKey) {
        return;
    }
    if (char === keys.ZOOM_RESET && (event.ctrlKey || event.metaKey)) {
        event.preventDefault();
        reset();
        setTimeout(() => __awaiter(void 0, void 0, void 0, function* () {
            const { eventBus } = yield Promise.resolve().then(() => require('@kui-shell/core'));
            eventBus.emit('/zoom', 1);
        }), 100);
    }
    else if ((char === keys.ZOOM_IN || char === keys.ZOOM_OUT) && (event.ctrlKey || event.metaKey) && !event.shiftKey) {
        yield injectContent();
        event.preventDefault();
        const main = document.querySelector('body > .page');
        const factor = char === keys.ZOOM_IN ? 1 : -1;
        const newZoom = parseInt(main.getAttribute('data-zoom') || '1', 10) + factor;
        _set(newZoom);
        setTimeout(() => __awaiter(void 0, void 0, void 0, function* () {
            const { eventBus } = yield Promise.resolve().then(() => require('@kui-shell/core'));
            eventBus.emit('/zoom', newZoom);
        }), 100);
    }
});
const get = () => {
    const main = document.querySelector('body > .page');
    return parseInt(main.getAttribute('data-zoom') || '1', 10);
};
function plugin(registrar) {
    if (typeof document === 'undefined')
        return;
    registrar.listen('/zoom/get', get, { usage: usage.get });
    registrar.listen('/zoom/set', set, { usage: usage.set });
    registrar.listen('/zoom/reset', reset, { usage: usage.reset });
}
exports.plugin = plugin;
function preload() {
    if (typeof document === 'undefined')
        return;
    document.addEventListener('keydown', listener);
}
exports.preload = preload;
//# sourceMappingURL=zoom.js.map