"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const help_1 = require("./lib/cmds/help");
const quit_1 = require("./lib/cmds/quit");
const clear_1 = require("./lib/cmds/clear");
const base64_1 = require("./lib/cmds/base64");
const open_ui_from_terminal_1 = require("./lib/cmds/open-ui-from-terminal");
const prompt_1 = require("./lib/cmds/prompt");
const sleep_1 = require("./lib/cmds/sleep");
const history_1 = require("./lib/cmds/history/history");
const confirm_1 = require("./lib/cmds/confirm");
exports.default = (commandTree, options) => __awaiter(void 0, void 0, void 0, function* () {
    yield Promise.all([
        help_1.default(commandTree, options),
        open_ui_from_terminal_1.default(commandTree),
        quit_1.default(commandTree),
        clear_1.default(commandTree),
        base64_1.default(commandTree),
        prompt_1.default(commandTree),
        sleep_1.default(commandTree),
        history_1.default(commandTree),
        confirm_1.default(commandTree)
    ]);
    if (!core_1.isHeadless()) {
        yield Promise.all([
            Promise.resolve().then(() => require('./lib/cmds/zoom')).then(_ => _.plugin(commandTree)),
            Promise.resolve().then(() => require('./lib/cmds/window')).then(_ => _.default(commandTree)),
            Promise.resolve().then(() => require('./lib/cmds/theme')).then(_ => _.plugin(commandTree))
        ]);
    }
});
//# sourceMappingURL=plugin.js.map