/*
 * Copyright 2017-19 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { isHeadless } from '@kui-shell/core';
import help from './lib/cmds/help';
import quit from './lib/cmds/quit';
import clear from './lib/cmds/clear';
import base64 from './lib/cmds/base64';
import openui from './lib/cmds/open-ui-from-terminal';
import prompt from './lib/cmds/prompt';
import sleep from './lib/cmds/sleep';
import history from './lib/cmds/history/history';
import confirm from './lib/cmds/confirm';
// import updater from './lib/admin/updater'
/**
 * This is the module
 *
 */
export default (commandTree, options) => __awaiter(void 0, void 0, void 0, function* () {
    yield Promise.all([
        help(commandTree, options),
        openui(commandTree),
        quit(commandTree),
        clear(commandTree),
        base64(commandTree),
        prompt(commandTree),
        sleep(commandTree),
        history(commandTree),
        confirm(commandTree)
    ]);
    if (!isHeadless()) {
        yield Promise.all([
            import('./lib/cmds/zoom').then(_ => _.plugin(commandTree)),
            import('./lib/cmds/window').then(_ => _.default(commandTree)),
            import('./lib/cmds/theme').then(_ => _.plugin(commandTree))
        ]);
    }
    // updater(commandTree) <-- disabled for now
});
//# sourceMappingURL=plugin.js.map