/*
 * Copyright 2017 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as assert from 'assert';
import { Common, CLI, Keys, ReplExpect, Selectors } from '@kui-shell/test';
Common.localDescribe('Text search', function () {
    before(Common.before(this));
    after(Common.after(this));
    // 2 matches test
    it('should add grumble to the repl', () => CLI.command('grumble', this.app)
        .then(ReplExpect.error(127))
        .catch(Common.oops(this)));
    it('should add another grumble to the repl', () => CLI.command('grumble', this.app)
        .then(ReplExpect.error(127))
        .catch(Common.oops(this)));
    it('should add bojangles to the repl', () => CLI.command('bojangles', this.app)
        .then(ReplExpect.error(127))
        .catch(Common.oops(this)));
    it('should open the search bar when cmd+f is pressed', () => __awaiter(this, void 0, void 0, function* () {
        yield this.app.client.keys([Keys.ctrlOrMeta, 'f']);
        yield this.app.client.waitForVisible('#search-bar');
    }));
    it('should not close the search bar if pressing esc outside of search input', () => __awaiter(this, void 0, void 0, function* () {
        yield this.app.client.click(Selectors.CURRENT_PROMPT_BLOCK);
        yield this.app.client.keys(Keys.ESCAPE);
        yield this.app.client.waitForVisible('#search-bar');
    }));
    it('should focus on search input when search input is pressed', () => __awaiter(this, void 0, void 0, function* () {
        yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
            yield this.app.client.click('#search-input');
            const hasFocus = yield this.app.client.hasFocus('#search-input');
            return hasFocus;
        }));
    }));
    it('should close the search bar if pressing esc in search input', () => __awaiter(this, void 0, void 0, function* () {
        yield this.app.client.setValue('#search-input', Keys.ESCAPE);
        yield this.app.client.waitForVisible('#search-bar', 2000, true); // reverse: true
    }));
    // re-open, so that we can test the close button
    // !!! Notes: some odd chrome or chromedriver bugs: if you click on
    // the close button, then chrome/chromedriver/whatever refuses to
    // accept any input; both setValue on the INPUT and the ctrlOrMeta+F
    // fail
    /* it('should open the search bar when cmd+f is pressed', async () => {
      await this.app.client.keys([Keys.ctrlOrMeta, 'f'])
      await this.app.client.waitForVisible('#search-bar')
    })
  
    it('should close the search bar if clicking the close button', async () => {
      await new Promise(resolve => setTimeout(resolve, 5000))
      await this.app.client.click('#search-close-button')
      await this.app.client.waitForVisible('#search-bar', 2000, true) // reverse: true
      await this.app.client.waitUntil(async () => {
        const hasFocus = await this.app.client.hasFocus(ui.Selectors.CURRENT_PROMPT)
        return hasFocus
      })
    }) */
    it('should find 4 matches for grumble', () => __awaiter(this, void 0, void 0, function* () {
        try {
            this.app.client.keys([Keys.ctrlOrMeta, 'f']);
            yield this.app.client.waitForVisible('#search-bar');
            yield this.app.client.waitUntil(() => this.app.client.hasFocus('#search-input'));
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                yield this.app.client.setValue('#search-input', `grumble${Keys.ENTER}`);
                const txt = yield this.app.client.getText('#search-found-text');
                return txt === '4 matches'; // two executions plus two 'Command not found: grumble' matches, and no tab title match!
            }));
        }
        catch (err) {
            yield Common.oops(this)(err);
        }
    }));
    // 1 match test
    it('should close the search bar if clicking the close button', () => this.app.client
        .click('#search-close-button')
        .then(() => this.app.client.waitForVisible('#search-bar', 2000, true)) // reverse: true
        .catch(Common.oops(this)));
    it('should find 3 matches for bojangles', () => this.app.client
        .keys([Keys.ctrlOrMeta, 'f'])
        .then(() => this.app.client.waitForVisible('#search-bar'))
        .then(() => this.app.client.waitUntil(() => this.app.client.hasFocus('#search-input')))
        .then(() => this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
        yield this.app.client.setValue('#search-input', `bojangles${Keys.ENTER}`);
        const txt = yield this.app.client.getText('#search-found-text');
        return txt === '3 matches'; // one execution, plus one "Command not found: bojangles" match, plus one tab title match
    })))
        .catch(Common.oops(this)));
    // no matches test
    it('should close the search bar if clicking the close button', () => this.app.client
        .click('#search-close-button')
        .then(() => this.app.client.waitForVisible('#search-bar', 2000, true)) // reverse: true
        .catch(Common.oops(this)));
    // re-open, so that we can test entering text and hitting enter
    it('should find nothing when searching for waldo', () => this.app.client
        .keys([Keys.ctrlOrMeta, 'f'])
        .then(() => this.app.client.waitForVisible('#search-bar'))
        .then(() => this.app.client.waitUntil(() => this.app.client.hasFocus('#search-input')))
        .then(() => this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
        yield this.app.client.setValue('#search-input', `waldo${Keys.ENTER}`);
        const txt = yield this.app.client.getText('#search-found-text');
        return txt === 'no matches';
    })))
        .catch(Common.oops(this)));
    // paste test; reload first to start with a clean slate in the text search box
    it('should reload the app', () => Common.refresh(this));
    it('should paste into the text search box', () => __awaiter(this, void 0, void 0, function* () {
        yield new Promise(resolve => setTimeout(resolve, 3000));
        return this.app.client
            .keys([Keys.ctrlOrMeta, 'f'])
            .then(() => this.app.client.waitForVisible('#search-bar'))
            .then(() => this.app.client.waitUntil(() => this.app.client.hasFocus('#search-input')))
            .then(() => this.app.electron.clipboard.writeText('grumble'))
            .then(() => this.app.client.execute(() => document.execCommand('paste')))
            .then(() => this.app.client.getValue('#search-input'))
            .then(actual => assert.strictEqual(actual, 'grumble')) // paste made it to #search-input?
            .catch(Common.oops(this, true));
    }));
});
//# sourceMappingURL=text-search.js.map