import { Tab, CommandLine } from '@kui-shell/core';
export interface TabCompletionSpec {
    toBeCompleted: string;
    toBeCompletedIdx: number;
}
export declare type CompletionResponse = string | {
    completion: string;
    addSpace: boolean;
    docs?: string;
    label?: string;
};
export declare function isStringResponse(response: CompletionResponse): response is string;
declare type Enumerator = (tab: Tab, commandLine: CommandLine, spec: TabCompletionSpec) => CompletionResponse[] | Promise<CompletionResponse[]>;
export declare function registerEnumerator(enumerator: Enumerator): void;
export declare function applyEnumerator(tab: Tab, commandLine: CommandLine, spec: TabCompletionSpec): Promise<CompletionResponse[]>;
export {};
