"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const usage_1 = require("../../usage");
const editCmd = ({ tab, argvNoOptions = [], parsedOptions = {}, execOptions }) => __awaiter(void 0, void 0, void 0, function* () {
    const [openEditor, applyOverrides, respondToRepl, { fetchEntity }, { persisters }] = yield Promise.all([
        Promise.resolve().then(() => require('../open')).then(_ => _.default),
        Promise.resolve().then(() => require('../overrides')).then(_ => _.default),
        Promise.resolve().then(() => require('../util')).then(_ => _.default),
        Promise.resolve().then(() => require('../fetchers')),
        Promise.resolve().then(() => require('../persisters'))
    ]);
    const { parameters: programmaticArgs } = execOptions;
    const positionalName = argvNoOptions[argvNoOptions.indexOf('edit') + 1];
    const name = (programmaticArgs && programmaticArgs.name) || positionalName;
    if (positionalName && positionalName.charAt(0) === '!') {
        if (programmaticArgs.filepath) {
            programmaticArgs.persister = persisters.files;
        }
        programmaticArgs.exec = {
            kind: parsedOptions.language,
            code: programmaticArgs[positionalName.slice(1)]
        };
    }
    const [entity, injectEntityIntoView] = yield Promise.all([
        programmaticArgs || fetchEntity(tab, name, parsedOptions, execOptions),
        openEditor(tab, name, parsedOptions, execOptions)
    ]);
    applyOverrides(parsedOptions)(entity);
    const model = yield injectEntityIntoView(entity);
    const custom = execOptions.custom;
    const lock = (custom && custom.lock) || (entity.lock !== undefined ? entity.lock : entity.gotoReadonlyView);
    return respondToRepl(lock ? [lock] : [])(model);
});
exports.edit = (tab, entity, options, execOptions) => editCmd({
    tab,
    argvNoOptions: [],
    parsedOptions: options,
    execOptions: Object.assign({}, execOptions, {
        parameters: entity,
        custom: undefined,
        noSidecarHeader: true
    })
});
exports.default = (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    commandTree.listen('/edit', editCmd, {
        usage: usage_1.editUsage('edit'),
        noAuthOk: true,
        inBrowserOk: true,
        needsUI: true
    });
});
//# sourceMappingURL=edit.js.map