"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
class MonacoEditorProvider {
    tryOpen(tab, custom, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const { edit } = yield Promise.resolve().then(() => require('./cmds/edit'));
            const projection = custom.content;
            const metadataBearer = core_1.isResourceByReference(custom) ? custom.resource : custom;
            const entity = {
                type: custom.prettyType,
                name: metadataBearer.metadata.name,
                kind: metadataBearer.kind,
                metadata: metadataBearer.metadata,
                noZoom: custom.noZoom,
                annotations: [],
                exec: {
                    kind: custom.contentType,
                    code: typeof projection !== 'string' ? JSON.stringify(projection, undefined, 2) : projection
                }
            };
            const { content } = yield edit(tab, entity, { readOnly: true }, options);
            return {
                content,
                presentation: core_1.Presentation.FixedSize
            };
        });
    }
}
function register() {
    core_1.registerEditor(new MonacoEditorProvider());
}
exports.default = register;
//# sourceMappingURL=editor-provider.js.map