import { ResourceWithMetadata } from '@kui-shell/core';
import { Persister } from './persisters';
interface ExecSpec {
    kind: string;
    code: string;
}
interface KeyValuePair {
    key: string;
    value: string;
}
export interface Entity extends ResourceWithMetadata {
    type: string;
    name: string;
    version?: string;
    isNew?: boolean;
    namespace?: string;
    noZoom?: boolean;
    viewName?: string;
    extract?: (raw: string, entity: Entity) => Entity;
    extractName?: (raw: string) => string;
    lock?: any;
    filepath?: string;
    exec: ExecSpec;
    persister?: Persister;
    gotoReadonlyView?: (Getter: any) => any;
    annotations: KeyValuePair[];
}
export default Entity;
