"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const path_1 = require("path");
const debug = debug_1.default('plugins/editor/fetchers');
const fetchers = [];
exports.registerFetcher = (fetcher) => {
    fetchers.push({ fetcher });
};
function createFile(tab, filepath, execOptions) {
    return tab.REPL.rexec(`touch ${tab.REPL.encodeComponent(filepath)}`, Object.assign({}, execOptions, { forceProxy: true }));
}
function createFilepath(tab, filepath, execOptions) {
    return __awaiter(this, void 0, void 0, function* () {
        const dir = path_1.dirname(filepath);
        const base = path_1.basename(filepath);
        if (base !== filepath) {
            debug('making parent directories', dir);
            yield tab.REPL.rexec(`mkdir -p ${tab.REPL.encodeComponent(dir)}`, Object.assign({}, execOptions, { forceProxy: true }));
        }
        return createFile(tab, filepath, execOptions);
    });
}
exports.fetchFile = (tab, filepath, parsedOptions, execOptions, createIfAbsent) => __awaiter(void 0, void 0, void 0, function* () {
    let stats;
    try {
        if (!tab) {
            const { getTabFromTarget, getCurrentPrompt } = yield Promise.resolve().then(() => require('@kui-shell/core'));
            tab = getTabFromTarget(getCurrentPrompt());
        }
        stats = (yield tab.REPL.rexec(`fstat ${tab.REPL.encodeComponent(filepath)} --with-data`)).content;
    }
    catch (err) {
        debug('error code', err.code);
        if (err.code === 404 && createIfAbsent) {
            debug('creating file');
            return createFilepath(tab, filepath, execOptions).then(() => exports.fetchFile(tab, filepath, parsedOptions, execOptions));
        }
        throw err;
    }
    if (stats.isDirectory) {
        throw new Error('Specified file is a directory');
    }
    else if (createIfAbsent) {
        throw new Error(`'${filepath}' cannot be created because it already exists`);
    }
    else {
        const name = path_1.basename(filepath);
        const dotIdx = filepath.lastIndexOf('.');
        const extension = dotIdx < 0 ? 'text' : filepath.substring(dotIdx + 1);
        const kind = extension === 'js' ? 'javascript' : extension === 'ts' ? 'typescript' : extension === 'py' ? 'python' : extension;
        const { persisters } = yield Promise.resolve().then(() => require('./persisters'));
        return {
            type: 'file',
            name,
            kind,
            filepath: stats.filepath,
            metadata: {
                name,
                namespace: path_1.dirname(stats.fullpath)
            },
            exec: {
                kind,
                code: stats.data
            },
            annotations: [],
            persister: persisters.files
        };
    }
});
exports.fetchEntity = (tab, entityName, parsedOptions, execOptions) => __awaiter(void 0, void 0, void 0, function* () {
    if (!parsedOptions.create) {
        for (let idx = 0; idx < fetchers.length; idx++) {
            const { fetcher } = fetchers[idx];
            try {
                const entity = yield fetcher(tab, entityName, parsedOptions, execOptions, false);
                if (entity) {
                    return entity;
                }
            }
            catch (err) {
                debug('got error from fetcher', err.code, err.statusCode, err);
                if (err.code !== 404) {
                    throw err;
                }
            }
        }
    }
    debug('treating this as an createIfAbsent edit of a local filepath');
    return exports.fetchFile(tab, entityName, parsedOptions, execOptions, true);
});
exports.registerFetcher(exports.fetchFile);
//# sourceMappingURL=fetchers.js.map