"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const monaco_editor_1 = require("monaco-editor");
const defaults_1 = require("./defaults");
const debug = debug_1.default('plugins/editor/init/esm');
let initDone;
exports.default = (editorWrapper, options) => {
    debug('init');
    const ready = () => new Promise(resolve => {
        core_1.injectCSS({
            css: require('monaco-editor/min/vs/editor/editor.main.css').toString(),
            key: 'editor.monaco.core'
        });
        const initEditor = () => __awaiter(void 0, void 0, void 0, function* () {
            if (!initDone) {
                initDone = true;
            }
            const editor = monaco_editor_1.editor.create(editorWrapper, Object.assign(defaults_1.default(options), options));
            editor['clearDecorations'] = () => {
                const none = [{ range: new monaco_editor_1.Range(1, 1, 1, 1), options: {} }];
                editor['__cloudshell_decorations'] = editor.deltaDecorations(editor['__cloudshell_decorations'] || [], none);
            };
            editorWrapper['editor'] = editor;
            resolve(editor);
        });
        initEditor();
    });
    return ready();
};
//# sourceMappingURL=esm.js.map