/// <reference types="node" />
import { EventEmitter } from 'events';
import { editor as MonacoEditor } from 'monaco-editor';
import { MultiModalResponse, ResourceWithMetadata, Tab, ToolbarText } from '@kui-shell/core';
import { Entity as EditorEntity } from './entity';
export interface Editor extends MonacoEditor.ICodeEditor {
    updateText: (entity: EditorEntity) => void;
}
export interface EditorState {
    tab: Tab;
    getEntity: () => EditorEntity;
    editor: Editor;
    eventBus: EventEmitter;
    toolbarText: ToolbarText;
}
export interface EditorResponse extends EditorState {
    content: HTMLElement;
}
export declare type EditorResource = ResourceWithMetadata<HTMLElement>;
export declare type CommandResponse = MultiModalResponse<EditorResource>;
export default EditorResponse;
