import { Tab, ExecOptions } from '@kui-shell/core';
import { Entity as EditorEntity } from './entity';
import { EditorResponse } from './response';
/**
 * Open the code editor
 *
 * @return a function that can be passed an entity to display in the
 * editor, and which returns { getEntity, editor, content }
 *     - getEntity(): returns the entity model
 *     - editor: an instance of the monaco editor class
 *     - content: a dom that contains the instance; this must be attached somewhere!
 *
 */
export declare const openEditor: (tab: Tab, name: string, options: any, execOptions: ExecOptions) => Promise<(entity: EditorEntity) => Promise<EditorResponse>>;
export default openEditor;
