"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const plugin_kubeui_1 = require("@kui-shell/plugin-kubeui");
const exec_1 = require("./exec");
const command_prefix_1 = require("../command-prefix");
const debug = debug_1.default('k8s/view/helm-status');
const width = (table) => {
    return table.reduce((max, { name, attributes }) => {
        return Math.max(max, name.length + attributes.reduce((sum, { value }) => sum + value.length, 0));
    }, 0);
};
exports.format = (options, response, execOptions) => __awaiter(void 0, void 0, void 0, function* () {
    const command = 'kubectl';
    const verb = 'get';
    debug('nested?', execOptions.nested);
    debug('command', command);
    debug('verb', verb);
    const [headerString, resourcesString, notesString] = response.split(/RESOURCES:|(?=NOTES:)/);
    const namespaceMatch = response.match(/^NAMESPACE:\s+(.*)$/m) || [];
    const namespaceFromHelmStatusOutput = namespaceMatch[1];
    debug('namespace', namespaceFromHelmStatusOutput);
    const namespaceFor = () => {
        return namespaceFromHelmStatusOutput;
    };
    const resources = resourcesString
        .split(/==>/)
        .map(_ => _.split(/[\n\r]/))
        .filter(A => A.length > 0 && A[0])
        .map(A => {
        const kind = A[0].trim();
        const entityType = kind.replace(/(v\w+\/)?([^()]*)(\s*\(.*\))?/, '$2');
        if (!/\s*NAME(\s+|$)/.test(A[1])) {
            const match = A[1].match(/(.+\s+)(.+)/);
            if (match && match[1]) {
                const secondColIdx = match[1].length;
                const firstCol = 'NAME';
                const secondCol = 'AGE';
                const spaces = (nSpaces) => new Array(nSpaces).join(' ');
                const header = `${firstCol}${spaces(secondColIdx - firstCol.length)}${secondCol}`;
                A.splice(1, 0, header);
            }
        }
        return {
            kind,
            table: plugin_kubeui_1.formatTable(command, verb, entityType, Object.assign({}, options, { namespace: namespaceFor() }), plugin_kubeui_1.preprocessTable([A.slice(1).join('\n')])[0])
        };
    });
    debug('resources', resources);
    const resourcesOut = resources
        .map(({ kind, table }) => {
        table.title = kind;
        return table;
    })
        .sort((a, b) => {
        const diff1 = a.header.attributes.length - b.header.attributes.length;
        if (diff1 === 0) {
            return -(width(a.body) - width(b.body));
        }
        else {
            return -diff1;
        }
    });
    if (execOptions.nested) {
        debug('returning tables for nested call', resourcesOut);
        return resourcesOut;
    }
    else {
        const result = [];
        if (headerString) {
            result.push(yield headerString);
        }
        if (Array.isArray(resourcesOut)) {
            resourcesOut.forEach(_ => result.push(_));
        }
        else {
            result.push(resourcesOut);
        }
        if (notesString) {
            result.push(yield notesString);
        }
        return result;
    }
});
function doStatus(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield exec_1.default(args);
        return exports.format(args.parsedOptions, response, args.execOptions);
    });
}
exports.default = (registrar) => {
    registrar.listen(`/${command_prefix_1.default}/helm/status`, doStatus, {
        inBrowserOk: true
    });
};
//# sourceMappingURL=status.js.map