"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@kui-shell/test");
const assert = require("assert");
const utils_1 = require("@kui-shell/plugin-kubeui/tests/lib/k8s/utils");
const lists = ['list', 'ls'];
describe(`helm commands ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(test_1.Common.before(this));
    after(test_1.Common.after(this));
    const ns = utils_1.createNS();
    const inNamespace = `--namespace ${ns}`;
    const name = `test-release-${ns}`;
    it('should show 500 error for helm help --tls', () => {
        return test_1.CLI.command('helm help --tls', this.app)
            .then(test_1.ReplExpect.error(500, 'Error: unknown flag: --tls'))
            .catch(test_1.Common.oops(this, true));
    });
    it('should show 500 error for helm get', () => {
        return test_1.CLI.command('helm get', this.app)
            .then(test_1.ReplExpect.error(500, 'Error: release name is required'))
            .catch(test_1.Common.oops(this, true));
    });
    it('should show 500 error for helm get -h', () => {
        return test_1.CLI.command('helm get -h', this.app)
            .then(test_1.ReplExpect.error(500))
            .catch(test_1.Common.oops(this, true));
    });
    it('should show 500 error for helm create', () => {
        return test_1.CLI.command('helm create', this.app)
            .then(test_1.ReplExpect.error(500, 'Error:'))
            .catch(test_1.Common.oops(this, true));
    });
    it('should show 500 error for helm install', () => {
        return test_1.CLI.command('helm install', this.app)
            .then(test_1.ReplExpect.error(500, 'Error:'))
            .catch(test_1.Common.oops(this, true));
    });
    it('should show 500 error for helm delete', () => {
        return test_1.CLI.command('helm delete', this.app)
            .then(test_1.ReplExpect.error(500, 'Error:'))
            .catch(test_1.Common.oops(this, true));
    });
    utils_1.allocateNS(this, ns);
    lists.forEach(list => {
        it(`should list empty releases via helm ${list}`, () => {
            return test_1.CLI.command(`helm ${list}`, this.app)
                .then(test_1.ReplExpect.blank)
                .catch(test_1.Common.oops(this));
        });
    });
    const checkHelmInstall = (res) => __awaiter(this, void 0, void 0, function* () {
        yield test_1.ReplExpect.okWithAny(res);
        yield test_1.SidecarExpect.open(res.app).then(test_1.SidecarExpect.showing(name, undefined, true));
    });
    const checkHelmStatus = (res) => __awaiter(this, void 0, void 0, function* () {
        yield test_1.ReplExpect.okWithAny(res);
        const table = yield this.app.client.getText(`${test_1.Selectors.OUTPUT_N(res.count)} .result-table-title`);
        assert.strict.equal(table.length, 6);
        const text = yield this.app.client.getText(`${test_1.Selectors.OUTPUT_N(res.count)} .kui--mixed-response--text`);
        assert.ok(Array.isArray(text), 'expect more than one section of text output');
        if (Array.isArray(text)) {
            assert.ok(text.find(x => x && x.includes('NOTES:')), 'expect a NOTES section of streaming output');
            assert.ok(text.find(x => x && x.includes('LAST DEPLOYED:')), 'expect a LAST DEPLOYED section of streaming output');
        }
    });
    it(`should create sample helm chart`, () => {
        return test_1.CLI.command(`helm install --name ${name} stable/mysql ${inNamespace}`, this.app)
            .then(checkHelmInstall)
            .catch(test_1.Common.oops(this));
    });
    it('should refresh as a quick way to close the sidecar', () => test_1.Common.refresh(this));
    it(`should show history`, () => {
        return test_1.CLI.command(`helm history ${name}`, this.app)
            .then(test_1.ReplExpect.okWithCustom({ selector: test_1.Selectors.TABLE_CELL('1', 'REVISION') }))
            .then(test_1.Util.expectText(this.app, '1'))
            .catch(test_1.Common.oops(this));
    });
    it(`should list that new release via helm list`, () => {
        return test_1.CLI.command(`helm list`, this.app)
            .then(test_1.ReplExpect.okWith(name))
            .catch(test_1.Common.oops(this));
    });
    it(`should list that new release via helm list`, () => {
        return test_1.CLI.command(`helm list`, this.app)
            .then(test_1.ReplExpect.okWithCustom({ selector: test_1.Selectors.TABLE_CELL(name, 'REVISION') }))
            .then(test_1.Util.expectText(this.app, '1'))
            .catch(test_1.Common.oops(this));
    });
    it(`should show the status of that new release`, () => {
        return test_1.CLI.command(`helm status ${name}`, this.app)
            .then(checkHelmStatus)
            .catch(test_1.Common.oops(this));
    });
    it(`should show the release in sidecar via helm get`, () => {
        return test_1.CLI.command(`helm get ${name}`, this.app)
            .then(test_1.ReplExpect.justOK)
            .then(test_1.SidecarExpect.open)
            .then(test_1.SidecarExpect.showing(name))
            .then(() => this.app.client.click(test_1.Selectors.SIDECAR_MODE_BUTTON('hooks')))
            .then(() => this.app.client.click(test_1.Selectors.SIDECAR_MODE_BUTTON('manifest')))
            .then(() => this.app.client.click(test_1.Selectors.SIDECAR_MODE_BUTTON('values')))
            .then(() => this.app.client.click(test_1.Selectors.SIDECAR_MODE_BUTTON('notes')))
            .catch(test_1.Common.oops(this));
    });
    it(`should delete sample helm chart`, () => {
        return test_1.CLI.command(`helm delete --purge ${name}`, this.app)
            .then(test_1.ReplExpect.okWithString(`release "${name}" deleted`))
            .catch(test_1.Common.oops(this));
    });
    it(`should list empty releases via helm list again`, () => {
        return test_1.CLI.command(`helm list`, this.app)
            .then(test_1.ReplExpect.blank)
            .catch(test_1.Common.oops(this));
    });
    utils_1.deleteNS(this, ns);
});
//# sourceMappingURL=helm.js.map